var UTIL = new(function() {

    this.pID = function(p) {
        try {
            return p.getName();
        } catch (e) {
            return 'unknown';
        }
    }

    // helper method to create a menu separator
    this.sep = function() {
        addUserCommand('undefined', function() {});
    }

    // link together thumbnail painters allowing them to work together
    this.thumbLink = function(tpainter) {

        var _setThumbnailPainter = setThumbnailPainter;

        var setLinkedThumbnailPainter = function(p) {

            if (p != null) {

                if (typeof p === 'function') {
                    var temp = p;
                    p = {};
                    p.paint = temp;
                }
                var tp = tpainter;
                if (typeof tpainter === 'function') {
                    var tp = {};
                    tp.paint = tpainter;
                }
                var linkPainter = function(gfx, image, ig, pp) {
                    p.paint(gfx, image, ig, pp);
                    tp.paint(gfx, image, ig, pp);

                }

                _setThumbnailPainter(linkPainter);

            } else {

                _setThumbnailPainter(tpainter);
            }

        }

        function redirect() {
            var proxied = setLinkedThumbnailPainter;

            this.setThumbnailPainter = function() {
                return proxied.apply(this, arguments);
            };
        }

        redirect();

    }


})();

// ComboPainter
// Pass in multiple "painter" objects or functions in the constructor to create a painter 
// that combines all of them together. Example: setPainter(new ComboPainter(Psych.getPainter(), BW.getPainter()));

function ComboPainter() {

    var pArray = arguments;
    var name = '';
    for (var i = 0; i < pArray.length; i++) {

        var p = pArray[i];
        if (typeof p.useCache !== "undefined") {
            // this is a CachingPainter. Turn off caching as ComboPainter does this already
            // no use having each painter keeping a cached image
            p.useCache(false);
        }

        name += UTIL.pID(p);
        if (i < pArray.length - 1) {
            name += '-';
        }
    }

    var painter = function(gfx, image, img, pp) {

        var r = pp.getImageRect(image);
        var subimage = image.getSubimage(r.x, r.y, r.width, r.height);

        var destImage = new java.awt.image.BufferedImage(r.width, r.height, java.awt.image.BufferedImage.TYPE_INT_ARGB);

        var bgfx = destImage.getGraphics();
        bgfx.drawImage(subimage, 0, 0, null);

        var newProps = pp.clone();

        newProps.imageX = 0;
        newProps.imageY = 0;

        for (var i = 0; i < pArray.length; i++) {

            var p = pArray[i];

            if (typeof p === 'function') {
                p(bgfx, destImage, destImage, newProps);
            } else {
                p.paint(bgfx, destImage, destImage, newProps);

            }
        };

        gfx.drawImage(destImage, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);
        bgfx.dispose();

    }


    return JSI.namedPainter(painter, name);

}


// BufferedPainter
// Create a buffered painter from another painter. A buffered painter will save the filtered image 
// for subsequent repaints (scrolling, dragging, popup tooltips or menus). In this example, the 
// Psych painter is buffered to prevent normally expensive repainting:
// setPainter(new BufferedPainter(Psych.getPainter())); 

function BufferedPainter(p) {
    var name = 'BUFFERED[';
    try {
        name += p.getName() + ']';
    } catch (e) {
	p = JSI.namedPainter(p, null);
        name += p.getName() + ']';
    }

    var cp = null;
    var graal = script_engine_name === 'graal.js';
    var rhino = script_engine_name === 'rhino';
    var nashorn = script_engine_name === 'nashorn';

    if (typeof p.useCache !== "undefined") {
        // this is a CachingPainter. Turn off caching as this painter does that
        // no use having each painter keeping a cached image
        p.useCache(false);
	name = p.getName();
    }
    var painter = function(gfx, image, img, pp) {

        // get ref to super. note the cp which is defined below. this is an alternate way
        // to subclass in nashorn
        if (rhino) {
            _super_ = this;
        } else {
            _super_ = Java.super(cp); // get reference to 'super'
        }

        // see if there's a cached image
        var bw = _super_.getCacheObject(pp);
        var mySuper = _super_;

        if (bw == null) {

            var r = pp.getImageRect(image);
            var subimage = image.getSubimage(r.x, r.y, r.width, r.height);

            var destImage = new java.awt.image.BufferedImage(r.width, r.height, java.awt.image.BufferedImage.TYPE_INT_ARGB);

            var bgfx = destImage.getGraphics();
            bgfx.drawImage(subimage, 0, 0, null);

            var newProps = pp.clone();

            newProps.imageX = 0;
            newProps.imageY = 0;


            if (typeof p === 'function') {

                p(bgfx, destImage, destImage, newProps);
            } else {
                p.paint(bgfx, destImage, destImage, newProps);
            }


            gfx.drawImage(destImage, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);
            bgfx.dispose();
            // save cached image until image changes
            mySuper.setCacheObject(destImage, pp);
        } else {
            gfx.drawImage(bw, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);
        }
    }

    if (graal || nashorn) {
        var C = Java.extend(Java.type('photogrok.CachingPainter'));
        cp = new C({
            paint: painter,
            getName: function() {
                return name;
            }
        });


    } else { // rhino
        cp = new JavaAdapter(CachingPainter, {
            paint: painter,
            getName: function() {
                return name;
            }
        });
    }

    return cp;

}
