// Create a dialog for adjusting brightness, contrast, highlights and shadows
// Algorithms by chatGPT
// Requires PhotoGrok 2.70 or later

var Tone = new(function() {
    var brightness = 0;
    var contrast = 1;
    var highlight = 255;
    var shadow = 0;
    var saveBrightness = null;
    var saveContrast = null;
    var saveShadow = null;
    var saveHighlight = null;

    var z = JSI;

    this.help = function() {
        showMessage('<html>Tone - create dialog to adjust brightness, contrast, highlights and shadows<br>(algorithms by chatGPT)<br><li>getPainter()');
    }

    addUserCommand('tone', function() {
        Tone.help();
    }, 'Help');


    this.setBrightness = function(b) {
        brightness = b;
    }

    this.setContrast = function(c) {
        contrast = c;
    }

    // chatgpt brightness -255 to 255. cqontrast 0 to 1
    function createBrightnessContrastTable(brightness, contrast) {
        var lutLength = 256;
        var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, 1, lutLength);
        for (var i = 0; i < lutLength; i++) {
            var val = ((i - 128) * contrast) + 128 + brightness;
            byteLookupArrays[0][i] = Math.max(0, Math.min(255, val));
        }

        return new java.awt.image.ByteLookupTable(0, byteLookupArrays);
    }

    function createImageAdjustmentTableNashorn(brightness, contrast, shadow, highlight) {
        var lutLength = 256;
        var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, 1, lutLength);

        for (var i = 0; i < lutLength; i++) {
            var val = i;
            if (val < shadow) {
                val = shadow - (shadow - val) * 0.5;
            } else if (val > highlight) {
                val = highlight + (val - highlight) * 0.5;
            }
            val = ((val - 128) * contrast) + 128 + brightness;

            byteLookupArrays[0][i] = Math.max(0, Math.min(255, val));

        }

        return new java.awt.image.ByteLookupTable(0, byteLookupArrays);
    }


    function createImageAdjustmentTableRhino(brightness, contrast, shadow, highlight) {
        var lutLength = 256;
        var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, 1, lutLength);

        for (var i = 0; i < lutLength; i++) {
            var val = i;
            if (val < shadow) {
                val = shadow - (shadow - val) * 0.5;
            } else if (val > highlight) {
                val = highlight + (val - highlight) * 0.5;
            }
            val = ((val - 128) * contrast) + 128 + brightness;

            // toSignedByte needed for Rhino
            byteLookupArrays[0][i] = toSignedByte(Math.max(0, Math.min(255, val)));

        }

        return new java.awt.image.ByteLookupTable(0, byteLookupArrays);
    }

    function createImageAdjustmentTableGraal(brightness, contrast, shadow, highlight) {
        var lutLength = 256;
        var byteLookupArrays = java.lang.reflect.Array.newInstance(java.lang.Byte.TYPE, 1, lutLength);

        for (var i = 0; i < lutLength; i++) {
            var val = i;
            if (val < shadow) {
                val = shadow - (shadow - val) * 0.5;
            } else if (val > highlight) {
                val = highlight + (val - highlight) * 0.5;
            }
            val = ((val - 128) * contrast) + 128 + brightness;

            byteLookupArrays[0][i] = truncate(toSignedByte(Math.max(0, Math.min(255, val))));

        }

        return new java.awt.image.ByteLookupTable(0, byteLookupArrays);
    }

    function truncate(number) {
        return number < 0 ? Math.ceil(number) : Math.floor(number);
    }

    var createTable = null;
    if (script_engine_name === 'rhino')
        createTable = createImageAdjustmentTableRhino;
    else if (script_engine_name === 'nashorn')
        createTable = createImageAdjustmentTableNashorn;
    else
        createTable = createImageAdjustmentTableGraal;

    function toSignedByte(value) {
        if (value > 127) {
            return -(256 - value);
        } else {
            return value;
        }
    }

    function saveState() {
        saveBrightness = brightness;
        saveContrast = contrast;
        saveShadow = shadow;
        saveHighlight = highlight;
    }

    function restoreState() {
        brightness = saveBrightness;
        contrast = saveContrast;
        shadow = saveShadow;
        highlight = saveHighlight;
        z.repaintImage();
    }

    this.getPainter = function() {

        var painter = function(gfx, image, img, pp) {

            var r = pp.getImageRect(image);
            var outImage = new java.awt.image.BufferedImage(r.width, r.height, image.getType());
            var table = createTable(brightness, contrast, shadow, highlight);
            var op = new java.awt.image.LookupOp(table, null);
            op.filter(image.getSubimage(r.x, r.y, r.width, r.height), outImage);

            gfx.drawImage(outImage, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);


        }


        return JSI.namedPainter(painter, 'Tone');
    }

    var toneFunc = function(){
        var currPainter = z.getPainter();
        var si = function() {

            var toneApplied = UTIL.pID(currPainter).indexOf('Tone') != -1;
            if (!toneApplied && (currPainter == null || currPainter.getName().indexOf('Filler') != -1))
                setPainter(Tone.getPainter());
            else if (!toneApplied)
                setPainter(new ComboPainter(Tone.getPainter(), currPainter), 'Tone');

            var panel = new javax.swing.JPanel(new java.awt.GridLayout(8, 1));
            var slider = new javax.swing.JSlider(-255, 255);
            slider.setValue(brightness);
            slider.addChangeListener(function(ce) {

                brightness = slider.getValue();
                z.repaintImage();
            });
            panel.add(new javax.swing.JLabel('Brightness'));
            panel.add(slider);
            panel.add(new javax.swing.JLabel('Contrast'));
            var contrastSlider = new javax.swing.JSlider(0, 100);
            contrastSlider.setValue(50);
            contrastSlider.addChangeListener(function(ce) {

                contrast = contrastSlider.getValue() / 50;
                z.repaintImage();
            });
            panel.add(contrastSlider);

            var shadowSlider = new javax.swing.JSlider(0, 255);
            shadowSlider.setValue(shadow);
            shadowSlider.addChangeListener(function(ce) {
                shadow = shadowSlider.getValue();
                z.repaintImage();
            });

            panel.add(new javax.swing.JLabel('Shadows'));
            panel.add(shadowSlider);

            var hlSlider = new javax.swing.JSlider(0, 255);
            hlSlider.setValue(highlight);
            hlSlider.addChangeListener(function(ce) {
                highlight = hlSlider.getValue();
                z.repaintImage();
            });

            panel.add(new javax.swing.JLabel('Highlights'));
            panel.add(hlSlider);
            return panel;
        }

        saveState();
        z.swingRequest(si, function(ok) {

            if (!ok) {
                restoreState();
                if (currPainter != null && currPainter.getName().indexOf('LINKED') != -1) {
                    setPainter(null, 'Tone');
                } else {
                    setPainter(currPainter);
                }
            }

        }, 'Tone');
    }

    addUserCommand("Tone", toneFunc);
    JSI.addShortcut(toneFunc, java.awt.event.KeyEvent.VK_T, java.awt.event.InputEvent.CTRL_DOWN_MASK | java.awt.event.InputEvent.SHIFT_DOWN_MASK);
})();
