var PAINTERLINKER = new(function() {
    var painterList = [];
    this.linked = false;
    var _setPainter = setPainter;

    this.help = function(){
        showMessage('<html>PAINTERLINKER<br>Once activated, painters are applied to the image in the order added. This works best for non-opaque painters. For example,<br>' +
		'combining Filler with Histogram, etc. Using "Link" from the "User" menu and then adding painters manually or via the menu<br>' + 
		'is the most convenient way to link painters together.<br><li>link(): start linking added painters</li><li>unlink(): unlink all linked painters</li><li>addPainter(painter, id)</li></html>');
    }

    addUserCommand('painterlinker', function() {
        PAINTERLINKER.help();
    }, 'Help');

    this.addPainter = function(p, pid) {

        if (p != null) {
            p = JSI.namedPainter(p, pid);
            pid = p.getName();
        }

        if (!PAINTERLINKER.linked) {
            _setPainter(p, pid);
            return;
        }
        if (p == null) {
            for (var i = 0; i < painterList.length; i++) {
                if (painterList[i].id === pid) {
                    //print('removing: ' + pid);
                    painterList.splice(i, 1);
                    break;
                }
            }


            if (painterList.length == 0 || pid === 'reset') {
                _setPainter(null, pid);
                painterList = [];
                PAINTERLINKER.linked = pid !== 'reset';
                return;
            }
            linkPainters(pid);
        } else {


            if (typeof p === 'function') {
                var pObj = {};
                pObj.paint = p;
                painterList[painterList.length] = {
                    'id': pid,
                    'painter': pObj
                };
            } else {
                painterList[painterList.length] = {
                    'id': pid,
                    'painter': p
                };
            }

            linkPainters(pid);

        }
    }

    function linkPainters(pid) {

        if (painterList.length > 0) {
            var name = "LINKED:";
            for (var i = 0; i < painterList.length; i++) {
                name += painterList[i].painter.getName();
                if (i < painterList.length - 1) {
                    name += ":";
                }

            }
            var linkPainter = function(gfx, image, ig, pp) {
                for (var i = 0; i < painterList.length; i++) {
                    painterList[i].painter.paint(gfx, image, ig, pp);
                }

            }

            _setPainter(linkPainter, name);

        }
    }

    this.link = function() {
        painterList = [];
        _setPainter(null, 'link');
        PAINTERLINKER.linked = true;
    }

    this.unlink = function() {
        painterList = [];
        _setPainter(null, 'link');
        PAINTERLINKER.linked = false;
    }

    addUserCommand("Link", function() {

        showMessage('Painters will now be linked together.');
        PAINTERLINKER.link();
    }, 'undefined');


    addUserCommand("All", function() {
        PAINTERLINKER.unlink();
    }, 'Unlink');

    addUserCommand("Select", function() {
        if (painterList.length == 0) {
            showMessage('There are no linked painters.');
            return;
        } else {
            var jx = javax.swing;
            var awt = java.awt;
            var ca = [];
            var si = function() {

                var items = painterList.length + 1;
                var panel = new jx.JPanel(new awt.GridLayout(painterList.length + 1, 1));

                panel.add(new jx.JLabel('Select painters to remove from linked painters'));


                for (var i = 0; i < painterList.length; i++) {
                    var cb = new jx.JCheckBox(painterList[i].painter.getName());

                    panel.add(cb);
                    ca[ca.length] = cb;
                }

                return panel;
            }
            JSI.swingRequest(si, function(ok) {
                if (ok) {
                    for (var i = 0; i < ca.length; i++) {
                        if (ca[i].isSelected()) {
                            setPainter(null, ca[i].getText());
                            //print(ca[i].getText());
                        }
                    }
                }
            }, 'Unlink');
        }
    }, 'Unlink');


})();

var _linkedthis = this;

(function() {
    // log all calls to setPainter

    var proxied = PAINTERLINKER.addPainter;

    _linkedthis.setPainter = function() {

        return proxied.apply(this, arguments);

    };
})();
