var GPSThumbnails = new (function(){

	// jump through hoops for rhino
	function getRGB(r, g, b, a){
		var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8)  | ((b & 0xFF) << 0);
		return new java.awt.Color(val, true);
	
	}

	addTreeFilter('GPSLatitude,FileName,Directory', 'GPSThumbnails.match(GPSLatitude,FileName,Directory)');

	var imgList = null;

	this.help = function(){
		var help = '<html>GPSThumbnails<br>Display compass icon on thumbnail screen for images with GPS data.<br>'
				+ 'Links with other thumbnail painters using thumbLink function from util.js.<br><br>'
				+ 'Catalog must include GPSLatitude tag.';
		showMessage(help);	
	}

	addUserCommand('gpsthumbnails', function(){
		GPSThumbnails.help();
	}, 'Help');

	var onBuildTree = function(cat){
		imgList = new java.util.ArrayList();
		getMap().remove("imglist");
	}

	registerCallback('onBuildTree', onBuildTree);

	this.match = function(gps, fn, d){
		if(gps != '-'){
			var val = fn + '' + d;
			imgList.add(val);
		}
		return true;
	}

	var done = function(){
		getMap().put("imglist", imgList);
	
	}

	registerCallback('done', done);

	imgList = getMap().get("imglist");

	var tpainter = function(gfx, image, ig, pp){
	
		if(imgList != null){
			var val = pp.file + '' + pp.dir;
			if(imgList.indexOf(val) != -1){
				gfx.setRenderingHint(java.awt.RenderingHints.KEY_ANTIALIASING,
		                  java.awt.RenderingHints.VALUE_ANTIALIAS_ON);
				gfx.setColor(getRGB(255, 255, 255, 200));
				//gfx.fillRect(0,0,3,3);
				gfx.fillOval(0, 0, 15, 15);
				gfx.setColor(getRGB(255, 0, 0, 200));
				gfx.drawLine(7, 1, 7, 7);
				gfx.setColor(getRGB(100,100,100,200));
				gfx.drawLine(7, 8, 7, 13);
			}
		}
	
	};


	setThumbnailPainter(tpainter);

	// allow linkage with other thumbnail painters
	// try catch in case UTIL not available
	try{
		UTIL.thumbLink(tpainter);
	}catch(e){}


})();


