var GPS = new (function(){

this.help = function(){
	var help = '<html>GPS<br>Add popup menu items to copy and add gps coordinates to selected images.<br>'
			+ '<li>setLongitudeRef(char): W|E (default: W)</li>'
			+ '<li>setLatitudeRef(char): N|S (default: N)</li></html>'
			+ '"Copy GPS" copies the LAT/LON of the first selected image to the clipboard.\n'
			+ '"Add GPS" prompts for a LAT/LON and uses ExifTool to update selected images.\n\n'
			+ 'Please make sure images are backed up before editing. See ExifTool documentation.';
	showMessage(help);	
}

var lonRef = 'W';
this.setLongitudeRef = function(lnr){
	lonRef = lnr;
}

var latRef = 'N';
this.setLatitudeRef = function(ltr){
	latRef = ltr;
}

addUserCommand('gps', function(){
	GPS.help();
}, 'Help');

addMenuCommand("Add GPS", function(nodes){
	//var gps = request("Enter GPS");
	var cb = function(gps){
		if(gps == null || gps.isEmpty()){
			return;
		}

		var idx = gps.indexOf(' ');
		var lat = gps.substring(0, idx);
		var lon = gps.substring(idx + 1);

		for(var i = 0; i < nodes.length; i++){
			var node = nodes[i];

			setStatusText("Adding GPS: " + node.name, true);
			var cmd = ['-overwrite_original', '-GPSLongitudeRef=' + lonRef, '-GPSLongitude=' + lon, '-GPSLatitudeRef=' + latRef, '-GPSLatitude=' + lat, node.dir + java.io.File.separator + node.name]; 
			var res = execExifTool(cmd);
			refreshFile(node.dir, node.name);
	
		}

		setStatusText(null, false);
	}
	request("Enter GPS", cb);
});


addMenuCommand("Copy GPS", function(nodes){

	var cmd = ['-s', '-n', '-GPSLatitude', '-GPSLongitude', nodes[0].dir + java.io.File.separator + nodes[0].name];
	var res = execExifTool(cmd);
	if(res.length != 2){
		showMessage("No GPS");
		return;
	}
	var copiedLat = parseValue(res[0]);
	var copiedLon = parseValue(res[1]);
	var ss = new java.awt.datatransfer.StringSelection(copiedLat + ' ' + copiedLon);
	var cb = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
	cb.setContents(ss, null);
	showMessage('Copied: ' + copiedLat + " " + copiedLon);
});

function parseValue(s){
	var idx = s.indexOf(':') + 2;
	return s.substring(idx);
}
})();
