// Filler
// fill the unused portion of the viewport with a magnified, blurred image (by default) similar to 
// effects seen in broadcasts displaying 4:3 content of 16:9 TV screens. 

// The painter function can't be used with BufferedPainter because Filler draws outside the image bounds. Caching
// is handled internally.

var Filler = new(function() {

    var painterId = 'Filler';
    var fillerPainter = null;
    var useImageColor = false;
    var stateChanged = false;

    //var isOn = false;
    var bgColor = null;

    this.help = function() {
        showMessage('<html>Filler<br>Fill viewport background with a magnified image or predominate color if useImageColor(true).<br><li>setFillerPainter(painter)</li>' +
            '<li>setOverlayPainter(painter)</li><li>useImageColor(boolean)</li><li>setColor(java.awt.Color)</li>');
    }

    this.useImageColor = function(b) {

        useImageColor = b;
        bgColor = null;
        stateChanged = true;

    }

    this.setColor = function(c) {
        useImageColor = false;
        bgColor = c;
        stateChanged = true;
    }

    addUserCommand('filler', function() {
        Filler.help();
    }, 'Help');

    var rhino = script_engine_name === 'rhino';
    var graal = script_engine_name === 'graal.js';
    var nashorn = script_engine_name === 'nashorn';
    // provide paint function

    var p = function(gfx, image, img, pp) {

        var r = pp.getImageRect(image);

        var sw = new java.awt.image.BufferedImage(r.width, r.height, java.awt.image.BufferedImage.TYPE_INT_ARGB);

        var g = sw.getGraphics();
        g.drawImage(image.getSubimage(r.x, r.y, r.width, r.height), 0, 0, null);
        g.dispose();
        image = sw;

        if (rhino) {
            _super_ = this;
        } else {
            _super_ = Java.super(cpainter); // get reference to 'super'
        }

        var bw = _super_.getCacheObject(pp); // see if image already cached

        if (stateChanged) {
            bw = null;
            stateChanged = false;
        }
        if (bw == null) {

            var iw = img.getWidth();
            var ih = img.getHeight();

            // fill in the unused portion of the display with a magnified and blurred image

            if ((!useImageColor && bgColor == null) && (iw > pp.viewWidth && ih > pp.viewHeight && (image.getWidth() < pp.viewWidth || image.getHeight() < pp.viewHeight))) {

                var bw = new java.awt.image.BufferedImage(pp.viewWidth, pp.viewHeight, java.awt.image.BufferedImage.TYPE_INT_RGB);

                var bgfx = bw.getGraphics();

                var backX = (iw / 2) - (pp.viewWidth / 2);
                var backY = (ih / 2) - (pp.viewHeight / 2);
                var subImage = img.getSubimage(parseInt(backX, 10), parseInt(backY, 10), pp.viewWidth, pp.viewHeight);
                bgfx.drawImage(subImage, 0, 0, null);

                if (fillerPainter == null) {
                    // create a blur filter
                    var jhFilter = new com.jhlabs.image.GaussianFilter();
                    jhFilter.setRadius(50);
                    jhFilter.filter(bw, bw);
                } else {
                    var newProps = pp.clone();
                    newProps.imageX = 0;
                    newProps.imageY = 0;
                    newProps.scaledWidth = pp.viewWidth;
                    newProps.scaledHeight = pp.scaledHeight;


                    if (typeof fillerPainter === 'function') {

                        fillerPainter(bgfx, bw, bw, newProps);
                    } else {
                        fillerPainter.paint(bgfx, bw, bw, newProps);
                    }
                }

                bgfx.drawImage(image, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);

                if (overlayPainter != null) {
                    if (typeof overlayPainter === 'function') {
                        overlayPainter(bgfx, bw, bw, pp);
                    } else {
                        overlayPainter.paint(bgfx, bw, bw, pp);
                    }
                }
                bgfx.dispose();

                // save the image in the cache so repaint not required until image changes
                _super_.setCacheObject(bw, pp);

                gfx.drawImage(bw, 0, 0, null);
            } else {
                gfx.setColor(bgColor == null ? getAverageColor(image) : bgColor);
                gfx.fillRect(0, 0, pp.viewWidth, pp.viewHeight);
                _super_.setCacheObject(bw, pp);
                gfx.drawImage(image, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);
            }

        } else {
            gfx.drawImage(bw, 0, 0, null);
        }

    };

    function getAverageColor(image) {
        var width = image.getWidth();
        var height = image.getHeight();
        var sumr = 0,
            sumg = 0,
            sumb = 0;
        for (var x = 0; x < width; x++) {
            for (var y = 0; y < height; y++) {
                var pixel = image.getRGB(x, y);
                sumr += (pixel & (255 << 16)) >> 16;
                sumg += (pixel & (255 << 8)) >> 8;
                sumb += (pixel & 255);
            }
        }
        var numPixels = width * height;

        return getRGB(sumr / numPixels, sumg / numPixels, sumb / numPixels, 255.0);
    }

    // jump through hoops for rhino
    function getRGB(r, g, b, a) {
        var val = ((a & 0xFF) << 24) | ((r & 0xFF) << 16) | ((g & 0xFF) << 8) | ((b & 0xFF) << 0);
        return new java.awt.Color(val, true);

    }


    var cpainter = null;
    if (graal || nashorn) {
        var C = Java.extend(Java.type('photogrok.CachingPainter'));
        //cpainter = new C(p);
        cpainter = new C({
            paint: p,
            getName: function() {
                return painterId;
            }
        });
    } else if (rhino) {
        cpainter = new JavaAdapter(CachingPainter, {
            paint: p,
            getName: function() {
                return painterId;
            }
        });
    }

    this.setFillerPainter = function(painter) {
        if (typeof painter.useCache !== "undefined") {
            // this is a JSImagePainter. Turn off caching as filler already caches. Also,
            // the filler image will never change if the passed in painter also caches.
            painter.useCache(false);
        }
        fillerPainter = painter;
    }

    this.on = function() {
        if (UTIL.pID(JSI.getPainter()).indexOf(painterId) == -1) {
            setPainter(cpainter, painterId);

        }
    }

    this.off = function() {

        if (UTIL.pID(JSI.getPainter()).indexOf(painterId) != -1) {
            setPainter(null, painterId);

        }
    }

    addUserCommand("Filler", function() {

        if (UTIL.pID(JSI.getPainter()).indexOf(painterId) == -1) {
            // on for current painter
            setPainter(cpainter);
        } else {
            setPainter(null);
        }

    });

    this.setOverlayPainter = function(op) {
        overlayPainter = op;
    }
    var overlayPainter = null;

})();
