var FaceDetect = new (function(){

	var painterId = 'facedetect';
	var isOn = false;
	
	var rhino = script_engine_name === 'rhino';

	this.help = function(){
		showMessage('<html>FaceDetect<br>Toggle face detection using jquery and jquery.facedetection.js.<br><li>setInterval(int)</li>');
	}

	addUserCommand('facedetect', function(){
		FaceDetect.help();
	}, 'Help');
	
	// add a top-level user menu item to implement face detection
	var interval = 3;
	var prompt = false;
	
	this.setInterval = function(i){
		interval = i;
	}
	
	this.prompt = function(p){
		prompt = p;
	}

	var jquery = null;
	var faceLib = null;
	var trigger = null;
	var libs = null;
	var queryPainter = null;

	function init(){
		jquery = readFromURL('http://www.metaloupe.com/js/jquery-3.2.1.min.js');
		faceLib = readFromURL('http://www.metaloupe.com/js/jquery.facedetection.min.js');
		
		// trigger script to tell the facedetection library to operate on our canvas
		// pg.done must be called with the object we want to pass back to this script
		// unless the object is a simple string or number, it is likely you will have
		// to stringify it to work with it
		
		trigger = "$('#pgcanvas').faceDetection({\n" +
		"interval: " + interval + ",\n" +
		"complete: function (faces) {\n" +
		"    pg.done(JSON.stringify(faces));\n" +
		"}\n" +
		"});\n";
	
	
		// must wrap in array instead of using varargs for signature to match with extend
		libs = [jquery, faceLib];

		if(rhino){
			queryPainter = new JavaAdapter(JSQueryPainter, {
				paint: painter	
			}, trigger, libs);
		}else{
	        	// nashorn method to extend a java class
	     	var jsqp = Java.extend(JSQueryPainter);
			queryPainter = new jsqp(trigger, libs) {
				paint: painter
			}
		}			
	}

	var painter = function(gfx, image, ig, pp) {
		var _super_ = null;
		if(rhino){
			_super_ = this;
		}else{
				_super_ = Java.super(queryPainter);
		}
		// call super.paint to get the js filtered image
		var faces = _super_.getCacheObject(pp);
		
		if(faces == null){
		       var rect = pp.getImageRect(image);
		       // no cached faces for this image, get from browser js
		       var obj = _super_.query(image.getSubimage(rect.x, rect.y, rect.width, rect.height));
		       faces = JSON.parse(obj); // un-stringify
		}
		
		// draw rects around each face and show confidence level
		gfx.setColor(java.awt.Color.yellow);
		var y = 20;
		for(var i = 0; i < faces.length; i++){
		
		       var face = faces[i];
			// parseInt needed for graal.js as it doesn't convert types automagically
		       gfx.drawRect(parseInt(face.x + Math.max(pp.imageX, 0)), parseInt(face.y + Math.max(pp.imageY, 0)), parseInt(face.width), parseInt(face.height));
		       gfx.drawString("Confidence: " + face.confidence, 20, y);
		       y += 20;
		
		
		}
		// store faces so we can reuse until image changes
		_super_.setCacheObject(faces, pp);
	
	};	


	this.on = function(){
		setPainter(queryPainter, painterId);
		isOn = true;
	}
	
	this.off = function(){
		setPainter(null, painterId);
		isOn = false;
	}	
	
	addUserCommand("Face Detect", function(){
	
		if(!isOn && prompt){
		        var intval = request('Enter interval');
	        	if(intval == null){
	                	return;
	        	}
	        	var iv = parseInt(intval);
	
	        	if(isNaN(iv)){
	                	showMessage('invalid input - not a whole number');
	                	return;
	        	}
	        	if(iv < 0){
	                	showMessage('invalid input - negative number');
	                	return;
	        	}
	
			interval = iv;
		}
		if(queryPainter == null){
			init(); // only do this once
		}
		isOn ? FaceDetect.off() : FaceDetect.on();
	
	});

	var linkerExists = null;

	function linkerCheck(){
		if(linkerExists == null){
			linkerExists = false;
			try{	
				var p = PAINTERLINKER;
				linkerExists = true;
			}catch(e){}
		}
	}
	var painterChanged = function(p){
		linkerCheck();
		if((!linkerExists || !PAINTERLINKER.linked) && p !== painterId){
			isOn = false;
		}
	}

	registerCallback('onPainterChanged', painterChanged);	

})();

