var RawConverter = new (function(){

	this.help = function(){
		showMessage('<html>RawConverter<br>Convert RAW to TIF with a javascript version of dcraw');	
	}

	addUserCommand('dcraw', function(){
		RawConverter.help();
	}, 'Help');

	load('http://www.metaloupe.com/js/dcraw.js');

	var writeFile = function(file, jso){
		var length = jso.length;
		var fos = new java.io.BufferedOutputStream(new java.io.FileOutputStream(file));
		for(var i = 0; i < length; i++){
			fos.write(jso[i]);
		}
		fos.flush();
		fos.close();
	
	}

	addMenuCommand("dcraw", function(nodes){
		var cb = function(dir){

			if(dir == null){
				return;
			}
			var outDir = new java.io.File(dir);
			if(outDir.isDirectory()){
				// run in background to block user input and prevent perceived lockup
				var run = function(){
					for each(var node in nodes){
						setStatusText('Converting ' + node.name, true);
						convert(node.dir, node.name, outDir);
					}
					setStatusText(null, false);	
				}
				background(run, null);
						
			}else{
				showMessage("Invalid Directory Path");
			}
		}

		request("Enter output directory path", cb);

	});

	function convert(dir, name, outDir){
		
		var start = java.lang.System.currentTimeMillis();

		var file = new java.io.File(dir, name);
		var array = java.nio.file.Files.readAllBytes(file.toPath());
		
		var pgbuffer = new Uint8Array(array.length);
	
		for(var i = 0; i < array.length; i++){
	
			pgbuffer[i] = array[i] & 0xff;
		}
		
		var tiffFile = dcraw(pgbuffer, {T: true, h: true});
		
		var outFile = new java.io.File(outDir, name + '.TIF');
		writeFile(outFile, tiffFile);
		print('file saved: ' + outFile);
		var end = java.lang.System.currentTimeMillis();
		print("elapsed: " + (end - start));

	}

})();
