var DateFilter = new (function(){
	var filterDate = null;
	var key = null;

	this.help = function(){
		showMessage('<html>DateFilter - build catalog tree for photos taken on requested date.<br>Works with existing filters.');
	}

	addUserCommand('datefilter', function(){
		DateFilter.help();
	}, 'Help');

	addUserCommand('Date Filter', function(){
		var f = function(d){
			if(d == null || d == ''){
				return;
			}
			filterDate = new Date(d);
			key = addTreeFilter('DateTimeOriginal', 'DateFilter.match(DateTimeOriginal)');
			buildTree(true, null);
			
		}
		
		request('Enter Date (yyyy-MM-dd)', f);
	});

	this.match = function(dto){
		if(dto == '-'){
			return false;
		}
		var d = convertDate(dto);
		return d.getFullYear() == filterDate.getFullYear() && d.getDate() == (filterDate.getDate() + 1) && filterDate.getMonth() == d.getMonth();
	}

	registerCallback('done', function(){
		removeTreeFilter(key);
		key = null;
	});

})();
