// add a simple b&w image filter that caches the image and only paints that part of the
// image that's visible. This implementation requires the BufferedPainter function
// found in util.js (always loaded first in example code)
var BW = new (function(){

	this.help = function(){
		showMessage('<html>BW - simple grayscale filter<br><li>getPainter()');	
	}

	addUserCommand('bw', function(){
		BW.help();
	}, 'Help');

	this.getPainter = function(){
		var painter = 	function(gfx, image, img, pp){

			var r = pp.getImageRect(image);
			
			var bw = new java.awt.image.BufferedImage(r.width, r.height, java.awt.image.BufferedImage.TYPE_BYTE_GRAY);  

			var g = bw.getGraphics(); 
			g.drawImage(image.getSubimage(r.x, r.y, r.width, r.height), 0, 0, null);  
			g.dispose();  
		

			gfx.drawImage(bw, Math.max(pp.imageX, 0), Math.max(pp.imageY, 0), null);			
				
		}

		return JSI.namedPainter(painter, 'BW');
	}


	addUserCommand("BW", function(){
	
		setPainter(new BufferedPainter(BW.getPainter()));
	});


})();
