/*
 * Decompiled with CFR 0.152.
 */
package loader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ToolLoader {
    private static ToolLoader loader;

    private ToolLoader() {
    }

    public String getVersion() {
        return "10.20";
    }

    public String extract(String dir, String file) throws FileNotFoundException, IOException {
        String path = null;
        byte[] buf = new byte[1024];
        BufferedInputStream bis = new BufferedInputStream(this.getClass().getResourceAsStream(file));
        ZipInputStream zipinputstream = null;
        zipinputstream = new ZipInputStream(bis);
        ZipEntry zipentry = zipinputstream.getNextEntry();
        while (zipentry != null) {
            File exeFile;
            String entryName = zipentry.getName();
            File f = new File(System.getProperty("user.home"), dir);
            if (!f.exists()) {
                f.mkdir();
            }
            if ((exeFile = new File(f, entryName)).isDirectory()) {
                exeFile.mkdirs();
            } else {
                int n;
                exeFile.getParentFile().mkdirs();
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(exeFile));
                while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                    bos.write(buf, 0, n);
                }
                bos.close();
            }
            zipinputstream.closeEntry();
            zipentry = zipinputstream.getNextEntry();
            if (!exeFile.getName().startsWith("exiftool")) continue;
            path = exeFile.getAbsolutePath();
        }
        zipinputstream.close();
        return path;
    }

    public static synchronized ToolLoader get() {
        if (loader == null) {
            loader = new ToolLoader();
        }
        return loader;
    }
}

